import pandas as pd   
import pickle
from decision_company import read_csv_file, count_unique_values

# Load the dataset      
credit_customers = read_csv_file("credit_customers.csv")   
  
# Calculate approval rates      
approval_rates_middle_aged = count_unique_values(middle_aged_customers['class'], normalize=True)      
approval_rates_stable_employment = count_unique_values(stable_employment_customers['class'], normalize=True)      
approval_rates_good_credit_history = count_unique_values(good_credit_history_customers['class'], normalize=True)      
 
print(approval_rates_middle_aged)
pickle.dump(approval_rates_middle_aged,open("./ref_result/approval_rates_middle_aged.pkl","wb"))

print(approval_rates_stable_employment)
pickle.dump(approval_rates_stable_employment,open("./ref_result/approval_rates_stable_employment.pkl","wb"))

print(approval_rates_good_credit_history)
pickle.dump(approval_rates_good_credit_history,open("./ref_result/approval_rates_good_credit_history.pkl","wb"))

  